### 29.2.3. Spring Data MongoDB仓库

Spring Data的仓库包括对MongoDB的支持。正如上面讨论的JPA仓库，基本的原则是查询会自动基于你的方法名创建。

实际上，不管是Spring Data JPA还是Spring Data MongoDB都共享相同的基础设施。所以你可以使用上面的JPA示例，并假设那个City现在是一个Mongo数据类而不是JPA　@Entity，它将以同样的方式工作。
```java
package com.example.myapp.domain;

import org.springframework.data.domain.*;
import org.springframework.data.repository.*;

public interface CityRepository extends Repository<City, Long> {

    Page<City> findAll(Pageable pageable);

    City findByNameAndCountryAllIgnoringCase(String name, String country);

}
```
